<?php

namespace App\Filament\Widgets;

use App\Models\Entry;
use App\Models\Publisher;
use Filament\Widgets\StatsOverviewWidget as BaseWidget;
use Filament\Widgets\StatsOverviewWidget\Stat;

class StatsOverview extends BaseWidget
{
    protected static ?int $sort = 0;
    protected function getStats(): array
    {
        return [
            Stat::make('Total Entries', Entry::count())->icon('heroicon-m-document-duplicate'),
            Stat::make('Published Entries', Entry::whereNotNull('publish_date')->count())->icon('heroicon-m-clipboard-document-check'),
            Stat::make('Total Publishers', Publisher::count())->icon('heroicon-m-user'),
        ];
    }
}
